jQuery(document).ready(function($) {

    function initializeCodeMirror() {
        console.log("Ejecutando inicialización de CodeMirror");

        // Verificar que codeSnippetManagerSettings está definido
        if (typeof codeSnippetManagerSettings !== 'undefined') {
            
            // Función para crear el botón de copiar
            function createCopyButton(editor) {
                var copyButton = $('<button class="copy-btn_codemirror_jz"><span class="dashicons dashicons-clipboard"></span> Copiar</button>');
           
                // Copiar el contenido al portapapeles
                copyButton.on('click', function() {
                    var content = editor.getValue();  // Obtener el contenido del editor
                    var textarea = $('<textarea>').val(content).appendTo('body');  // Crear un textarea temporal
                    textarea.select();  // Seleccionar el texto
                    document.execCommand('copy');  // Ejecutar el comando de copiar
                    textarea.remove();  // Eliminar el textarea temporal

                    // Feedback visual de que se ha copiado
                    copyButton.text('¡Copiado!');
                    setTimeout(function() {
                        copyButton.html('<span class="dashicons dashicons-clipboard"></span> Copiar');
                    }, 1000);
                });

                return copyButton;
            }

            // Aplicar CodeMirror en diferentes elementos según la clase
            function applyCodeMirror(selector, mode) {
                $(selector).each(function() {
                    var code = (mode === "htmlmixed") ? $(this).html() : $(this).text();  // Obtener el código
                    $(this).html('');  // Vaciar el contenido del contenedor

                    var textarea = $('<textarea></textarea>').text(code).appendTo(this);  // Crear un textarea virtual
                    var editor = CodeMirror.fromTextArea(textarea[0], {
                        mode: mode,  // Modo correspondiente
                        lineNumbers: false,
                        theme: codeSnippetManagerSettings.theme, // Usar el tema desde la variable
                        matchBrackets: true,
                        autoCloseBrackets: true,
                        styleActiveLine: true,
                        readOnly: true  // Hacerlo solo lectura (no editable)
                    });

                    // Crear el botón de copiar y agregarlo al contenedor
                    var copyButton = createCopyButton(editor);
                    $(this).css('position', 'relative');  // Asegurar que el contenedor tiene posición relativa
                    $(this).append(copyButton);
                });
            }

            // Aplicar CodeMirror a los diferentes tipos de código
            applyCodeMirror('.code-jz_js', "javascript");
            applyCodeMirror('.code-jz_css', "css");
            applyCodeMirror('.code-jz_html', "htmlmixed");

        } else {
            console.error('codeSnippetManagerSettings no está definido');
        }
    }

    // Ejecutar al cargar la página
    initializeCodeMirror();

    // Ejecutar cuando WPBakery recargue elementos en el frontend
    $(document).on("vc_reload vc.shortcodes.add", function() {
        console.log("WPBakery recargó elementos, reiniciando CodeMirror");
        initializeCodeMirror();
    });

});
